<?php
header('Content-Type: application/json');
require_once "config.php";

// Ambil data terakhir sensor
$stmt = $pdo->query("SELECT * FROM sensors ORDER BY id DESC LIMIT 1");
$sensor = $stmt->fetch();

// Ambil state
$stmt2 = $pdo->query("SELECT gpio2_state FROM device_state WHERE id=1");
$state = $stmt2->fetch();

if ($sensor) {
    echo json_encode([
        "t1" => $sensor["t1"],
        "t2" => $sensor["t2"],
        "t3" => $sensor["t3"],
        "mode" => $sensor["mode"],
        "created_at" => $sensor["created_at"],
        "gpio2_state" => $state ? $state["gpio2_state"] : 0
    ]);
} else {
    echo json_encode([
        "t1" => 0, "t2" => 0, "t3" => 0,
        "mode" => "UNKNOWN",
        "created_at" => null,
        "gpio2_state" => $state ? $state["gpio2_state"] : 0
    ]);
}
?>