<?php
require_once "config.php";

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // ESP32 ambil state
    $stmt = $pdo->query("SELECT gpio2_state FROM device_state WHERE id=1");
    $row = $stmt->fetch();
    header("Content-Type: application/json");
    echo json_encode([
        "gpio2" => $row ? intval($row['gpio2_state']) : 0
    ]);
    exit;

} elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Web (tombol) update state
    $state = isset($_POST['state']) ? intval($_POST['state']) : 0;
    $stmt = $pdo->prepare("UPDATE device_state SET gpio2_state=? WHERE id=1");
    $stmt->execute([$state]);

    // Redirect balik ke index.php biar user lihat hasilnya
    header("Location: ../index.php");
    exit;

} else {
    echo "Invalid request method.";
}
?>
