<?php
require_once "backend/config.php";

$stmt = $pdo->query("
    SELECT 
        DATE_FORMAT(created_at, '%Y-%m-%d %H:00:00') AS jam,
        AVG(t1) AS avg_t1,
        AVG(t2) AS avg_t2,
        AVG(t3) AS avg_t3,
        MAX(mode) AS mode
    FROM sensors
    GROUP BY DATE_FORMAT(created_at, '%Y-%m-%d %H')
    ORDER BY jam DESC
    LIMIT 72
");
$data = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html>
<head>
    <title>Histori Per Jam</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        table { border-collapse: collapse; width: 100%; margin-top: 20px; }
        th, td { border: 1px solid #ccc; padding: 8px; text-align: center; }
        th { background: #f4f4f4; }
        .mode-run { color: green; font-weight: bold; }
        .mode-def { color: red; font-weight: bold; }
        a { display: inline-block; margin-bottom: 15px; }
    </style>
</head>
<head>
  <meta charset="UTF-8">
  <title>History Suhu</title>
  <link rel="stylesheet" href="css/style.css">
  <style>
    /* Tambahan khusus untuk halaman history */
    table {
      font-size: 22px;   /* lebih besar */
      font-weight: bold; /* lebih tebal */
    }
    table th, table td {
      padding: 12px;     /* lebih longgar */
    }
  </style>
</head>
<body>
    <h2>Histori Suhu Per Jam (max 72 jam)</h2>
    <a href="index.php">⬅ Kembali ke Dashboard</a>
    <table>
        <tr>
            <th>Jam</th>
            <th>Rata-rata T1</th>
            <th>Rata-rata T2</th>
            <th>Rata-rata T3</th>
            <th>Mode</th>
        </tr>
        <?php foreach ($data as $row): ?>
        <tr>
            <td><?= $row['jam'] ?></td>
            <td><?= number_format($row['avg_t1'], 2) ?> °C</td>
            <td><?= number_format($row['avg_t2'], 2) ?> °C</td>
            <td><?= number_format($row['avg_t3'], 2) ?> °C</td>
            <td class="<?= ($row['mode']=="DEF") ? "mode-def" : "mode-run" ?>">
                <?= $row['mode'] ?>
            </td>
        </tr>
        <?php endforeach; ?>
    </table>
<nav style="margin-bottom: 20px; text-align:center;">
  <a href="index.php">🏠 Tampilan Utama</a> 
</nav>

</body>
</html>
