<?php require_once "backend/config.php"; ?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>ESP32 Monitoring</title>
  <style>
    body { 
      font-family: Arial, sans-serif; 
      margin: 0; 
      padding: 0; 
      background: #f8f9fa; 
    }
    header {
      background: #0d6efd;
      color: white;
      text-align: center;
      padding: 15px;
    }
    .container {
      max-width: 800px;
      margin: 0 auto;
      padding: 15px;
    }
    .card {
      background: white;
      border-radius: 10px;
      padding: 15px;
      margin-bottom: 20px;
      box-shadow: 0 2px 6px rgba(0,0,0,0.1);
    }
    .card h3 {
      margin-top: 0;
      margin-bottom: 10px;
    }
    .sensor-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
      gap: 15px;
      text-align: center;
    }
    .sensor-box {
      background: #f1f1f1;
      padding: 10px;
      border-radius: 8px;
    }
    .sensor-value {
      font-size: 1.4em;
      font-weight: bold;
    }
    .mode-run { color: green; font-weight: bold; }
    .mode-def { color: red; font-weight: bold; }
    .btn {
      display: inline-block;
      background: #0d6efd;
      color: white;
      border: none;
      border-radius: 8px;
      padding: 12px 20px;
      font-size: 1em;
      cursor: pointer;
      text-decoration: none;
      text-align: center;
    }
    .btn:hover {
      background: #0b5ed7;
    }
    footer {
      text-align: center;
      padding: 10px;
      font-size: 0.9em;
      color: #666;
    }
  </style>
</head>
<body>
  <header>
    <h2>📡 Temperatur Monitoring</h2>
  </header>

  <div class="container">
    <!-- Card Data -->
    <div class="card" id="sensor-data">
      <h3>Data Sensor Terbaru</h3>
      <div class="sensor-grid">
  <div class="sensor-box">
    <div>RUANG</div>
    <div class="sensor-value"><span id="t1">0</span> °C</div>
  </div>
  <div class="sensor-box">
    <div>EVAP</div>
    <div class="sensor-value"><span id="t2">0</span> °C</div>
  </div>
  <div class="sensor-box">
    <div>OPT</div>
    <div class="sensor-value"><span id="t3">0</span> °C</div>
  </div>
  <div class="sensor-box">
    <div>Mode</div>
    <div class="sensor-value"><span id="mode" class="mode-run">RUN</span></div>
  </div>
</div>

      <p style="margin-top:10px;">GPIO2: <span id="gpio2">0</span></p>
      <p>Update: <span id="created_at">-</span></p>
    </div>

    <!-- Tombol Push ON -->
    <form action="backend/state.php" method="POST" style="text-align:center;">
      <input type="hidden" name="state" value="1">
      <button type="submit" class="btn">Manual defroz</button>
    </form>
  </div>

  <footer>
    &copy; <?= date("Y") ?> ESP32 Monitor
  </footer>

  <script>
  function refreshData() {
    fetch("backend/latest.php?t=" + new Date().getTime())
      .then(res => res.json())
      .then(data => {
        document.getElementById("t1").innerText = data.t1;
        document.getElementById("t2").innerText = data.t2;
        document.getElementById("t3").innerText = data.t3;
        document.getElementById("mode").innerText = data.mode;
        document.getElementById("gpio2").innerText = data.gpio2_state;
        document.getElementById("created_at").innerText = data.created_at;

        const modeEl = document.getElementById("mode");
        if (data.mode === "DEF") {
          modeEl.className = "mode-def";
        } else {
          modeEl.className = "mode-run";
        }
      })
      .catch(err => console.error("Refresh error:", err));
  }
  refreshData();
  setInterval(refreshData, 5000);
  </script>
<nav style="margin-bottom: 20px;">
   
  <a href="history.php">📊 Histori Suhu</a>
</nav>

</body>
</html>
