<?php if (!defined('ALLOW_RENDER')) { http_response_code(403); exit; } ?>
<!DOCTYPE html>
<html lang="id">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="Cache-Control" content="no-store" />
    <title>Web Serial untuk ESP32/Arduino</title>
    <link rel="stylesheet" href="styles.css?v=4" />
    <!-- Gunakan base URL relatif agar cepat diakses di laptop maupun HP -->
    <script>
      // Backend base diset ke server ESP32: gunakan IP 10.240.231.135
      window.BACKEND_BASE_URL = 'mulaibaru/backend/';
    </script>
  </head>
  <body>
    <header>
      <h1>WEB MONITORING DAN KONTROL  TEMPERATUR</h1>
      <!-- Catatan penggunaan browser/Serial Monitor dihapus sesuai permintaan -->
    </header>

    <section class="controls">

      <div class="row">
        <button id="defrostBtn" disabled class="defrost-btn">Manual DEFROS</button>
      </div>

      <div class="row small">
        <span id="status">Status: belum terhubung</span>
        <button id="downloadBtn" class="ghost" disabled>Unduh log (.txt)</button>
      </div>
    </section>

    <section class="output">
      <div class="panes">
        <div class="pane">
          <h2>Telemetri</h2>
          <div id="telemetry" class="telemetry">
            <div class="tile"><div class="label">T1 (Ruang)</div><div class="value" id="t1Val">-</div></div>
            <div class="tile"><div class="label">T2 (Evap)</div><div class="value" id="t2Val">-</div></div>
            <div class="tile"><div class="label">T3 (Outdoor)</div><div class="value" id="t3Val">-</div></div>
            <div class="tile"><div class="label">Mode</div><div class="value" id="modeVal">-</div></div>
          </div>
          <div class="telemetry-meta">
            <div class="small">Terakhir update: <span id="lastUpdate">-</span></div>
            <div class="small">ESP32: <span id="espStatus" class="indicator-bad">tidak aktif</span></div>
            <div class="small">Durasi mode: <span id="modeDuration">-</span></div>
          </div>
        </div>
        <div class="pane">
          <h2>Status Relay</h2>
          <div id="relays" class="relay-grid">
            <div class="tile"><div class="label">RL1</div><div class="value" id="rl1Val">-</div></div>
            <div class="tile"><div class="label">RL2</div><div class="value" id="rl2Val">-</div></div>
            <div class="tile"><div class="label">RL3</div><div class="value" id="rl3Val">-</div></div>
          </div>
        </div>
        <div class="pane">
          <h2>Pengaturan Telemetri</h2>
          <div class="row">
            <label for="limitR">Batas T1 (R)</label>
            <div class="stepper">
              <button type="button" class="dec" data-target="limitR">−</button>
              <input id="limitR" type="number" step="0.1" inputmode="decimal" min="-999" placeholder="mis. 25.0" />
              <button type="button" class="inc" data-target="limitR">+</button>
            </div>
            <label for="limitE">Batas T2 (E)</label>
            <div class="stepper">
              <button type="button" class="dec" data-target="limitE">−</button>
              <input id="limitE" type="number" step="0.1" inputmode="decimal" min="-999" placeholder="mis. -3.0" />
              <button type="button" class="inc" data-target="limitE">+</button>
            </div>
            <label for="limitO">Batas T3 (O)</label>
            <div class="stepper">
              <button type="button" class="dec" data-target="limitO">−</button>
              <input id="limitO" type="number" step="0.1" inputmode="decimal" min="-999" placeholder="mis. 28.0" />
              <button type="button" class="inc" data-target="limitO">+</button>
            </div>
            <button id="applyLimitsBtn">Terapkan</button>
          </div>
        </div>
        <div class="pane">
          <h2>Terakhir (terparse)</h2>
          <pre id="parsed"></pre>
        </div>
        <div class="pane">
          <h2>Log (baris mentah)</h2>
          <pre id="log" class="log"></pre>
        </div>

        <div class="pane">
          <h2>Histori Temperatur (10 menit, 3 hari terakhir)</h2>
          <div class="row">
            <button id="historyRefreshBtn" class="btn-yellow">Refresh histori</button>
            <button type="button" class="btn-yellow" onclick="window.open('mulaibaru/backend/history_table.php','_blank')">Buka Tabel Histori</button>
          </div>
          <table id="historyTable" class="history">
            <thead>
              <tr>
                <th>Waktu</th>
                <th>Mode</th>
                <th>T1</th>
                <th>T2</th>
                <th>T3</th>
              </tr>
            </thead>
            <tbody id="historyTbody"></tbody>
          </table>
        </div>
      </div>
  </section>

  <footer>
      <!-- Informasi tips JSON dihapus sesuai permintaan -->
    </footer>

  <!-- Modal Konfirmasi Terapkan Batas -->
  <div id="applyConfirmModal" class="modal">
    <div class="modal-card">
      <h3>Konfirmasi Terapkan Batas</h3>
      <div class="modal-body">
        <div>R: <span id="applyConfirmR">(kosong)</span></div>
        <div>E: <span id="applyConfirmE">(kosong)</span></div>
        <div>O: <span id="applyConfirmO">(kosong)</span></div>
        <div class="small">Perubahan akan disimpan ke backend dan disinkronisasi ke perangkat.</div>
      </div>
      <div class="modal-actions">
        <button id="applyConfirmNo" class="ghost">Batal</button>
        <button id="applyConfirmYes" class="btn-yellow hold-button">
          <span>Ya, Terapkan</span>
          <div class="hold-bar"><div id="applyConfirmProgress" class="hold-progress"></div></div>
        </button>
      </div>
      <div class="small" style="margin-top:8px">Tahan tombol "Ya, Terapkan" selama 2 detik untuk konfirmasi.</div>
    </div>
  </div>

  <!-- Modal Konfirmasi Manual DEFROS -->
  <div id="defrostConfirmModal" class="modal">
    <div class="modal-card">
      <h3>Konfirmasi Manual DEFROS</h3>
      <div class="modal-body">
        <div class="small">Manual DEFROS akan dijalankan. RL2 (heater) akan ON.</div>
        <div class="small">Tahan tombol di bawah selama 2 detik untuk konfirmasi.</div>
      </div>
      <div class="modal-actions">
        <button id="defrostConfirmNo" class="ghost">Batal</button>
        <button id="defrostConfirmYes" class="btn-yellow hold-button">
          <span>Ya, DEFROS</span>
          <div class="hold-bar"><div id="defrostConfirmProgress" class="hold-progress"></div></div>
        </button>
      </div>
    </div>
  </div>

  <script src="main.js?v=4"></script>

</body>
  </html>
