<?php
// Gate akses sederhana tanpa login: cukup URL dengan kode akhir 54321
$REQUIRED_CODE = '12345';

function has_valid_code($required) {
    // Query param
    if (isset($_GET['code']) && $_GET['code'] === $required) return true;
    if (isset($_GET['c']) && $_GET['c'] === $required) return true;
    // Cookie
    if (isset($_COOKIE['access_code']) && $_COOKIE['access_code'] === $required) return true;
    // Path suffix (butuh rewrite agar /54321 diarahkan ke index.php)
    $uri = $_SERVER['REQUEST_URI'] ?? '/';
    $path = parse_url($uri, PHP_URL_PATH);
    $segments = array_values(array_filter(explode('/', $path)));
    if (!empty($segments) && end($segments) === $required) return true;
    return false;
}

// Jika query valid, set cookie agar akses berikutnya tidak perlu kode di URL
if ((isset($_GET['code']) && $_GET['code'] === $REQUIRED_CODE) || (isset($_GET['c']) && $_GET['c'] === $REQUIRED_CODE)) {
    setcookie('access_code', $REQUIRED_CODE, time() + 86400, '/'); // 1 hari
}

$valid = has_valid_code($REQUIRED_CODE);
if (!$valid) {
    http_response_code(403);
    ?><!doctype html>
    <html lang="id">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width,initial-scale=1">
        <title>Akses Ditolak</title>
        <style>
            body{background:#0b1120;color:#e5e7eb;font-family:system-ui,Segoe UI,Roboto,Helvetica,Arial,sans-serif;margin:0;display:flex;align-items:center;justify-content:center;min-height:100vh}
            .card{background:#111827;border:1px solid #1f2937;border-radius:12px;padding:20px;max-width:520px}
            h1{margin:0 0 8px;font-size:20px}
            .muted{color:#9ca3af;font-size:14px}
            code{background:#1f2937;padding:2px 4px;border-radius:6px}
            a{color:#ffd400}
        </style>
    </head>
    <body>
        <div class="card">
            <h1>Akses ditolak</h1>
            <p class="muted">Gunakan URL dengan kode akses untuk membuka halaman ini.</p>
            <p class="muted">Jika Anda menerima tautan dari administrator, buka tautan lengkap tersebut.</p>
        </div>
    </body>
    </html><?php
    exit;
}

// Kode valid → render aplikasi utama
define('ALLOW_RENDER', true);
require __DIR__ . '/app.php';
