<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
date_default_timezone_set('Asia/Jakarta');

// Preflight CORS
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
  http_response_code(204);
  exit;
}

$dir = __DIR__ . '/data';
$files = glob($dir . '/telemetry_*.csv');
if (!$files || empty($files)) { echo json_encode([]); exit; }

$rows = [];
foreach ($files as $csvFile) {
  $fh = fopen($csvFile, 'r');
  if (!$fh) { continue; }
  $headers = fgetcsv($fh);
  if (!$headers || !is_array($headers)) { $headers = []; }
  while (($row = fgetcsv($fh)) !== false) {
    $assoc = [];
    foreach ($headers as $i => $key) {
      $assoc[$key] = isset($row[$i]) ? $row[$i] : null;
    }
    $atStr = isset($assoc['at']) ? $assoc['at'] : null;
    $at = $atStr ? strtotime($atStr) : null;
    if (!$at) { continue; }
    $assoc['at'] = date('c', $at);
    $rows[] = $assoc;
  }
  fclose($fh);
}

$now = time();
$threeDaysAgo = $now - 3 * 24 * 3600; // 3 hari terakhir

// Ambil satu entri per blok 10 menit (terakhir dalam blok)
$blocks = [];
foreach ($rows as $item) {
  $atSec = strtotime($item['at']);
  if ($atSec < $threeDaysAgo) continue;
  $block = intdiv($atSec, 600); // 10 menit = 600 detik
  $blocks[$block] = $item; // timpa dengan yang terbaru pada blok yang sama
}

ksort($blocks); // urutkan naik berdasarkan waktu

$result = [];
foreach ($blocks as $b => $item) {
  // Konversi ke tipe yang sesuai
  $t1 = isset($item['t1']) && is_numeric($item['t1']) ? floatval($item['t1']) : null;
  $t2 = isset($item['t2']) && is_numeric($item['t2']) ? floatval($item['t2']) : null;
  $t3 = isset($item['t3']) && is_numeric($item['t3']) ? floatval($item['t3']) : null;
  $mode = isset($item['mode']) ? strtoupper(trim($item['mode'])) : null;
  $result[] = [
    'at' => $item['at'],
    'mode' => $mode,
    't1' => $t1,
    't2' => $t2,
    't3' => $t3,
  ];
}

echo json_encode($result, JSON_UNESCAPED_SLASHES);
?>
