<?php
header('Content-Type: text/html; charset=utf-8');
header('Access-Control-Allow-Origin: *');
date_default_timezone_set('Asia/Jakarta');

$dir = __DIR__ . '/data';
$rows = [];
$files = glob($dir . '/telemetry_*.csv');
if ($files) {
  foreach ($files as $csvFile) {
    $fh = fopen($csvFile, 'r');
    if (!$fh) { continue; }
    $headers = fgetcsv($fh);
    if (!$headers || !is_array($headers)) { $headers = []; }
    while (($row = fgetcsv($fh)) !== false) {
      $assoc = [];
      foreach ($headers as $i => $key) {
        $assoc[$key] = isset($row[$i]) ? $row[$i] : null;
      }
      $atStr = isset($assoc['at']) ? $assoc['at'] : null;
      $at = $atStr ? strtotime($atStr) : null;
      if (!$at) { continue; }
      $assoc['at'] = date('c', $at);
      $rows[] = $assoc;
    }
    fclose($fh);
  }
}

$now = time();
$threeDaysAgo = $now - 3 * 24 * 3600; // 3 hari terakhir

// Ambil satu entri per blok 10 menit (terakhir dalam blok)
$blocks = [];
foreach ($rows as $item) {
  $atSec = strtotime($item['at']);
  if ($atSec < $threeDaysAgo) continue;
  $block = intdiv($atSec, 600); // 10 menit = 600 detik
  $blocks[$block] = $item; // timpa dengan yang terbaru pada blok yang sama
}
ksort($blocks);
$result = [];
foreach ($blocks as $item) {
  $mode = isset($item['mode']) ? strtoupper(trim($item['mode'])) : null;
  $t1 = isset($item['t1']) && is_numeric($item['t1']) ? floatval($item['t1']) : null;
  $t2 = isset($item['t2']) && is_numeric($item['t2']) ? floatval($item['t2']) : null;
  $t3 = isset($item['t3']) && is_numeric($item['t3']) ? floatval($item['t3']) : null;
  $result[] = [
    'at' => $item['at'],
    'mode' => $mode,
    't1' => $t1,
    't2' => $t2,
    't3' => $t3,
  ];
}

function fmt($x) {
  if ($x === null || $x === '') return '-';
  if (!is_numeric($x)) return '-';
  return number_format((float)$x, 2, '.', '');
}

?><!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Histori Temperatur (10 menit, 3 hari)</title>
  <style>
    body { font-family: system-ui, -apple-system, Segoe UI, Roboto, Arial, sans-serif; margin: 20px; }
    h1 { font-size: 18px; margin: 0 0 12px; }
    table { width: 100%; border-collapse: collapse; }
    th, td { border: 1px solid #ccc; padding: 6px 8px; }
    thead th { background: #f5f5f5; }
    tbody tr:nth-child(even) { background: #fafafa; }
    /* Garis pembatas antar jam: baris pertama pada setiap jam diberi border-top lebih tebal */
    tr.hour-start td { border-top: 2px solid #888; }
    .badge { display: inline-block; padding: 2px 6px; border-radius: 6px; font-weight: 600; }
    .badge-run { background: #dbeafe; color: #1e40af; }
    .badge-def { background: #fee2e2; color: #b91c1c; }
    .note { color: #666; margin: 8px 0 14px; }
    .btn { display: inline-block; padding: 4px 10px; border: 1px solid #ccc; border-radius: 6px; text-decoration: none; background: #fff; color: #333; margin-left: 8px; }
    .btn:hover { background: #f5f5f5; }
    /* Tombol kuning */
    .btn-yellow { background-color: #ffd400; color: #222; border: 1px solid #c9ae00; padding: 6px 12px; border-radius: 6px; font-weight: 600; }
    .btn-yellow:hover { filter: brightness(1.05); }
  </style>
  <meta http-equiv="Cache-Control" content="no-store" />
  <meta http-equiv="Pragma" content="no-cache" />
  <meta http-equiv="Expires" content="0" />
  <script>
    function refreshPage(){ location.reload(); }
  </script>
  </head>
<body>
  <h1>Histori Temperatur (tiap 10 menit, 3 hari terakhir)</h1>
  <div class="note">Sumber: backend/data/telemetry_YYYY-MM-DD.csv. <button class="btn-yellow" onclick="refreshPage()">Refresh</button><a href="../../" class="btn btn-yellow">Kembali ke Dashboard</a></div>
  <table>
    <thead>
      <tr>
        <th>Waktu</th>
        <th>Mode</th>
        <th>T1</th>
        <th>T2</th>
        <th>T3</th>
      </tr>
    </thead>
    <tbody>
      <?php if (empty($result)): ?>
        <tr><td colspan="5" style="text-align:center;">Tidak ada data untuk 3 hari terakhir</td></tr>
      <?php else: ?>
        <?php 
          $prevHour = null; 
          foreach (array_reverse($result) as $row): // terbaru di atas 
            $currHour = date('Y-m-d H', strtotime($row['at']));
            $clsHour = ($prevHour !== $currHour) ? ' class="hour-start"' : '';
        ?>
          <tr<?php echo $clsHour; ?>>
            <td><?php echo htmlspecialchars(date('d-m-Y H:i', strtotime($row['at']))); ?></td>
            <td>
              <?php 
                $m = $row['mode'] ?: '-';
                $cls = ($m === 'DEF') ? 'badge badge-def' : (($m === 'RUN') ? 'badge badge-run' : 'badge');
              ?>
              <span class="<?php echo $cls; ?>"><?php echo htmlspecialchars($m); ?></span>
            </td>
            <td><?php echo htmlspecialchars(fmt($row['t1'])); ?></td>
            <td><?php echo htmlspecialchars(fmt($row['t2'])); ?></td>
            <td><?php echo htmlspecialchars(fmt($row['t3'])); ?></td>
          </tr>
        <?php 
            $prevHour = $currHour; 
          endforeach; 
        ?>
      <?php endif; ?>
    </tbody>
  </table>
  <p class="note">Buka langsung: <code>/backend/history_table.php</code> di server lokal.</p>
</body>
</html>
