<?php
header('Content-Type: application/json');
$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '*';
header('Vary: Origin');
header('Access-Control-Allow-Origin: ' . $origin);
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
date_default_timezone_set('Asia/Jakarta');

$dir = __DIR__ . '/data';
if (!is_dir($dir)) { @mkdir($dir, 0777, true); }

// Preflight untuk CORS
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
  http_response_code(204);
  exit;
}

// Jika GET dengan query last=1, kembalikan isi last.json
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['last'])) {
  $file = $dir.'/last.json';
  if (file_exists($file)) {
    $raw = file_get_contents($file);
    if ($raw === false) {
      http_response_code(500);
      echo json_encode(['error' => 'failed to read last.json']);
      exit;
    }
    // pastikan konten adalah JSON valid
    $data = json_decode($raw, true);
    if (!is_array($data)) {
      http_response_code(500);
      echo json_encode(['error' => 'last.json invalid']);
      exit;
    }
    echo json_encode($data, JSON_UNESCAPED_SLASHES);
    exit;
  } else {
    echo json_encode(['error' => 'last.json not found']);
    exit;
  }
}

// --- Di bawah ini adalah POST untuk menerima telemetri ---
$apiKey = $_POST['api_key'] ?? '';
$expectedKey = 'b2d7a1f0e9c44bb78a9031e5c6d2f41a7e3d9ac1';
if ($expectedKey !== '' && $apiKey !== $expectedKey) {
  http_response_code(401);
  echo json_encode(['error' => 'unauthorized']);
  exit;
}

function numOrNull($v) {
  if ($v === null || $v === '') return null;
  if (!is_numeric($v)) return null;
  return (float)$v;
}

$t1 = numOrNull($_POST['t1'] ?? null);
$t2 = numOrNull($_POST['t2'] ?? null);
$t3 = numOrNull($_POST['t3'] ?? null);
$mode = isset($_POST['mode']) ? strtoupper(trim($_POST['mode'])) : null; // RUN/DEF
$rl1 = isset($_POST['rl1']) ? intval($_POST['rl1']) : (isset($_POST['r1']) ? intval($_POST['r1']) : null);
$rl2 = isset($_POST['rl2']) ? intval($_POST['rl2']) : (isset($_POST['r2']) ? intval($_POST['r2']) : null);
$rl3 = isset($_POST['rl3']) ? intval($_POST['rl3']) : (isset($_POST['r3']) ? intval($_POST['r3']) : null);
$ip  = $_POST['ip'] ?? null;
$alarm = isset($_POST['alarm']) ? (intval($_POST['alarm']) ? 1 : 0) : null;
// Durasi mode (detik) dari ESP32 agar UI dapat menyelaraskan waktu mulai mode
$dur = isset($_POST['dur']) ? intval($_POST['dur']) : null;

$row = [
  'at' => date('c'),
  't1' => $t1, 't2' => $t2, 't3' => $t3,
  'mode' => $mode,
  'rl1' => $rl1, 'rl2' => $rl2, 'rl3' => $rl3,
  'ip' => $ip,
  'alarm' => $alarm,
  'dur' => $dur,
];

file_put_contents($dir.'/last.json', json_encode($row, JSON_UNESCAPED_SLASHES));
$csvFile = $dir.'/telemetry_'.date('Y-m-d').'.csv';
$isNew = !file_exists($csvFile);
$fp = fopen($csvFile, 'a');
if ($fp) {
  if ($isNew) { fputcsv($fp, array_keys($row)); }
  fputcsv($fp, array_map(function($v){ return is_bool($v) ? ($v?1:0) : $v; }, $row));
  fclose($fp);
}
$threshold = time() - 3 * 24 * 3600;
foreach (glob($dir.'/telemetry_*.csv') as $path) {
  $base = basename($path, '.csv');
  $d = substr($base, strlen('telemetry_'));
  $ts = strtotime($d);
  if ($ts !== false && $ts < $threshold) { @unlink($path); }
}

echo json_encode(['ok' => true]);
?>
