<?php
header('Content-Type: application/json');
// CORS longgar untuk pengujian lokal dashboard
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

$remoteBase = 'http://afikaservice.my.id/mulai/mulaibaru/backend/';
$url = $remoteBase . 'receive.php?last=1';

$ctx = stream_context_create([
  'http' => [
    'method' => 'GET',
    'timeout' => 3,
    'header' => "User-Agent: mulai-dashboard-proxy\r\n",
  ]
]);
$raw = @file_get_contents($url, false, $ctx);
if ($raw === false) {
  http_response_code(502);
  echo json_encode(['error' => 'proxy_fetch_failed', 'url' => $url]);
  exit;
}

// Validasi JSON
$data = json_decode($raw, true);
if (!is_array($data)) {
  // jika konten bukan JSON valid, kirim mentah agar bisa di-debug
  echo $raw;
  exit;
}
// sinkronkan ke file lokal agar dashboard dapat fallback ke local file
$dir = __DIR__ . '/data';
if (!is_dir($dir)) { @mkdir($dir, 0777, true); }
@file_put_contents($dir.'/last.json', json_encode($data, JSON_UNESCAPED_SLASHES));
echo json_encode($data, JSON_UNESCAPED_SLASHES);
?>
