<?php
header('Content-Type: application/json');
$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '*';
header('Vary: Origin');
header('Access-Control-Allow-Origin: ' . $origin);
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
date_default_timezone_set('Asia/Jakarta');

$dir = __DIR__ . '/data';
if (!is_dir($dir)) { @mkdir($dir, 0777, true); }
$file = $dir . '/state.json';

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

function read_state($file) {
  if (file_exists($file)) {
    $raw = file_get_contents($file);
    $data = json_decode($raw, true);
    if (is_array($data)) return $data;
  }
  return [ 'gpio2' => 0, 'limits' => [ 'R'=> null, 'E'=> null, 'O'=> null ], 'updated' => time() ];
}

function write_state($file, $state) {
  @file_put_contents($file, json_encode($state, JSON_UNESCAPED_SLASHES));
}

function numOrNull($v) {
  if ($v === null || $v === '') return null;
  if (!is_numeric($v)) return null;
  return (float)$v;
}

$state = read_state($file);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $changed = false;
  if (isset($_POST['state'])) {
    $s = intval($_POST['state']) ? 1 : 0;
    if (!isset($state['gpio2']) || $state['gpio2'] !== $s) { $state['gpio2'] = $s; $changed = true; }
  }
  $r = numOrNull($_POST['limitR'] ?? null);
  $e = numOrNull($_POST['limitE'] ?? null);
  $o = numOrNull($_POST['limitO'] ?? null);
  if ($r !== null || $e !== null || $o !== null) {
    if (!isset($state['limits']) || !is_array($state['limits'])) $state['limits'] = ['R'=>null,'E'=>null,'O'=>null];
    if ($r !== null) { $state['limits']['R'] = $r; $changed = true; }
    if ($e !== null) { $state['limits']['E'] = $e; $changed = true; }
    if ($o !== null) { $state['limits']['O'] = $o; $changed = true; }
  }
  if ($changed) { $state['updated'] = time(); write_state($file, $state); }
  echo json_encode(['ok'=>true,'limits'=>$state['limits'],'gpio2'=>$state['gpio2'],'updated'=>$state['updated']], JSON_UNESCAPED_SLASHES);
  exit;
}

echo json_encode(['limits'=>$state['limits'],'gpio2'=>$state['gpio2'],'updated'=>$state['updated']], JSON_UNESCAPED_SLASHES);
exit;
